package nemosofts.voxradio.executor;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.interfaces.CountriesListener;
import nemosofts.voxradio.item.ItemCountries;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AsyncTaskExecutor;
import okhttp3.RequestBody;

public class LoadCou extends AsyncTaskExecutor<String, String, String> {

    private final RequestBody requestBody;
    private final CountriesListener listener;
    private final ArrayList<ItemCountries> arrayList = new ArrayList<>();
    private String verifyStatus = "0";
    private String message = "";

    public LoadCou(CountriesListener listener, RequestBody requestBody) {
        this.listener = listener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        listener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String strings) {
        try {
            String json = ApplicationUtil.responsePost(Callback.API_URL, requestBody);
            JSONObject mainJson = new JSONObject(json);
            JSONArray jsonArray = mainJson.getJSONArray(Callback.TAG_ROOT);

            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject obj = jsonArray.getJSONObject(i);

                if (!obj.has(Callback.TAG_SUCCESS)) {
                    String id = obj.getString("cid");
                    String name = obj.getString("countries_name");
                    String image = obj.getString("countries_image").replace(" ", "%20");
                    if (image.isEmpty()) {
                        image = "null";
                    }
                    ItemCountries objItem = new ItemCountries(id, name, image);
                    arrayList.add(objItem);
                } else {
                    verifyStatus = obj.getString(Callback.TAG_SUCCESS);
                    message = obj.getString(Callback.TAG_MSG);
                }
            }
            return "1";
        } catch (Exception e) {
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        listener.onEnd(s, verifyStatus, message, arrayList);
    }
}